function make_smile(T)

    %%%%%%%%%%%%%%%%%%%%%%%%
    % Create Smile         %
    %%%%%%%%%%%%%%%%%%%%%%%%

    % Init points array
    points = [];

    % Create points for circle
    t = linspace(0, 360, 1000);
    x = cosd(t);
    y = sind(t);

    points = [points [x; y]];

    % Create points for eyes
    n = 100;
    x = -0.3*ones(1, n);
    y = linspace(0.1, 0.5, n);
    points = [points [x; y]];

    x =  0.3*ones(1, n);
    y = linspace(0.1, 0.5, n);
    points = [points [x; y]];

    % Create smile
    t = linspace(200, 340, 200);
    x = 0.618*cosd(t);
    y = 0.618*sind(t);
    points = [points [x; y]];

    % Now apply the transformation if one is given
    if nargin>0

        points_transformed = transform_points(points, T);

        % Now plot everything
        figure(1)
        clf;

        subplot(2, 1, 1)
        plot(points(1, :), points(2, :), '.')
        title('Original Smile')
        axis([-3, 3, -3, 3])
        axis equal
        ax=axis;
        grid on

        subplot(2, 1, 2)
        plot(points_transformed(1, :), points_transformed(2, :), 'r.')
        title('Transformed Smile')
        axis(ax)
        axis equal
        grid on

    else

        % Just plot the smile
        clf
        plot(points(1, :), points(2, :), '.')
        title('Smile')
        axis([-3, 3, -3, 3])
        axis equal
        grid on

    end

end
