function [K] = getCameraMatrix

    if 1
        im1 = imread('1.jpg');

        disp('Click on two points for first line segment.')
        disp('Then click on two points for second line segment.')
        disp('Then double click to say you are done.')
        disp(' ')

        disp('Find first vanishing point')
        v1 = [getVanishingPoint(im1) 1]'

        disp('Find second vanishing point')
        v2 = [getVanishingPoint(im1) 1]'

        disp('Find third vanishing point')
        v3 = [getVanishingPoint(im1) 1]'
    else

        % You can save your vanishing points here
        % so you don't have to click every time

        v1 = [0; 0; 1];
        v2 = [0; 0; 1];
        v3 = [0; 0; 1];
    end

    % We know that v_i * W * v_j = 0 if i!=j, so have three relationships
    % we can express. Doing the multiplication out, we have a matrix
    % equation A*w = 0, where A contains all of the coefficients and w
    % contains all of the non-zero elements of W.
    A = zeros(3, 4);

    % To find the elements of W, we just find the nullspace of A
    % We can just use the null function in MATLAB
    w_e = zeros(1, 4);

    % Now reconstruct the matrix w
    W = zeros(3, 3);

    % Compute K from W
    K = zeros(3, 3);

    % Normalize K so that K(3, 3) is one

end
