% HOG Parameters
cellsize = 10;
histsize = 9;

% Load image
im = imread('gronk.png');
im = rgb2gray(im);

[sz_x, sz_y] = size(im);

sz_x = sz_x - mod(sz_x, cellsize);
sz_y = sz_y - mod(sz_y, cellsize);

cells_x = sz_x/cellsize;
cells_y = sz_y/cellsize;

im = im(1:sz_x, 1:sz_y);
im = double(im);

% Compute gradients
[mag, theta] = compute_gradients(im);

% Compute cellwise histogram
cellhist = zeros(cells_x, cells_y, histsize);

for x=1:cells_x
    for y=1:cells_y

        i0 = (x-1)*cellsize + 1;
        j0 = (y-1)*cellsize + 1;

        hist = zeros(1, histsize);

        for i=1:cellsize
            for j=1:cellsize

                t_ij = theta(i0 + i - 1, j0 + j - 1);

                while t_ij<0
                    t_ij = t_ij + 180;
                end
                while t_ij>=180
                    t_ij = t_ij - 180;
                end

                % Find bins and weights
                [bin1, bin2, w1, w2] = put_in_histogram(t_ij, histsize);

                u = mag(i0 + i - 1, j0 + j - 1);
                hist(bin1) = hist(bin1) + w1*u;
                hist(bin2) = hist(bin2) + w2*u;
            end
        end

        cellhist(x, y, :) = hist;

    end
end

% Cells to blocks

blocksize = 2;
blockhist = zeros(cells_x-blocksize+1, cells_y-blocksize+1, histsize*blocksize*blocksize);

for x=1:cells_x-blocksize+1
    for y=1:cells_y-blocksize+1

        b_00 = cellhist(x, y, :);
        b_01 = cellhist(x, y+1, :);
        b_10 = cellhist(x+1, y, :);
        b_11 = cellhist(x+1, y+1, :);

        b = [b_00(:); b_01(:); b_10(:); b_11(:)];

        % add a small value to make sure norm is never 0
        b = b/(norm(b)+0.0001);

        blockhist(x, y, :) = b;

    end
end

% Final HOG feature
h = blockhist;

% Normalize
norm_h = norm(h(:));
h = h / norm_h;

% Clip
tau = 0.2;
h = min(h, tau);

% Renormalize
norm_h = norm(h(:));
h = h / norm_h;

% Plot things
figure(1)
clf
subplot(1, 2, 1)
imagesc(im)
axis equal
axis off
title('Image')
subplot(1, 2, 2)
visualizeHOG(h)
axis equal
title('HOG')

figure(2)
clf
subplot(1, 2, 1)
imagesc(mag)
axis equal
axis off
title('Magnitude')
subplot(1, 2, 2)
imagesc(theta)
axis equal
axis off
title('Direction (Degrees)')
