

% Create points %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

u1 = [1.5; 1.5];
sigma1 = 0.6;
n1 = 500;

u2 = [2; 4];
sigma2 = 0.4;
n2 = 200;

u3 = [4; 2.5];
sigma3 = 0.4;
n3 = 800;

pts1 = u1*ones(1,n1) + sigma1*randn(2, n1);
pts2 = u2*ones(1,n2) + sigma2*randn(2, n2);
pts3 = u3*ones(1,n3) + sigma3*randn(2, n3);
pts = [pts1 pts2 pts3];


% Plot points %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(1)
clf
plot(pts1(1, :), pts1(2, :), 'r.', 'MarkerSize', 12)
hold on
plot(pts2(1, :), pts2(2, :), 'g.', 'MarkerSize', 12)
plot(pts3(1, :), pts3(2, :), 'b.', 'MarkerSize', 12)
plot(u1(1), u1(2), 'kx', 'LineWidth', 12, 'MarkerSize', 30)
plot(u2(1), u2(2), 'kx', 'LineWidth', 12, 'MarkerSize', 30)
plot(u3(1), u3(2), 'kx', 'LineWidth', 12, 'MarkerSize', 30)
grid on
axis([0, 5, 0, 5]);
axis square

figure(2)
clf
plot(pts(1, :), pts(2, :), 'k.', 'MarkerSize', 12)
grid on
axis([0, 5, 0, 5]);
axis square

% Randomly select cluster centers to start with %%%%%%
c1 = [0; 0];
c2 = [0; 0];
c3 = [0; 0];

centers = [c1 c2 c3];
labels = zeros(length(pts), 1);

figure(3)
clf
plot(pts(1, :), pts(2, :), 'k.', 'MarkerSize', 12)
hold on
grid on
plot(centers(1, :), centers(2, :), 'cx', 'LineWidth', 12, 'MarkerSize', 30)
axis([0, 5, 0, 5]);
axis square

iteration = 0
while 1
    iteration = iteration + 1

    % Find labels for all points %%%%%%%%%%%%%%%

    figure(4)
    clf
    plot_points(pts, labels, centers);
    title(sprintf('Iteration %d (Expectation)', iteration))
    disp('Press Enter to continue... ')
    pause

    % Recompute cluster centers %%%%%%%%%%%%%%%%

    figure(4)
    clf
    plot_points(pts, labels, centers);
    title(sprintf('Iteration %d (Maximization)', iteration))
    disp('Press Enter to continue... ')
    pause

    % Check for termination %%%%%%%%%%%%%%%%%%%%

end
