function points_h = apply_transformation(points, H, noise)
% This function applies the transformation H to points. Additionally, additive
% Gaussian noise is applied as well.
%
%   points    The 3xN matrix that contains the homogeneous points to be
%             transformed
%   H         The 3x3 projective transformation
%   noise     Optionally, how much noise to apply

    % Apply transformation to H
    points_h = H*points;

    % Optionally, add some noise
    if nargin>2
        points_h(1, :) = points_h(1, :) + noise.*points(3, :).*randn(1, length(points_h));
        points_h(2, :) = points_h(2, :) + noise.*points(3, :).*randn(1, length(points_h));
    end

end
