%%%%% Some parameters for us to play with %%%%%%%%%

% Try adding more or less noise to the system to see how robust DLT is
% noise=0 is no noise, noise=0.05 is a lot of noise
noise = 0.0;

% Try increasing or decreasing the number of correspondences that are used
% Remember that we need at least 4.
n_correspondences = 4;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Get points for smile
points = init_smile();

% Get projective transformation
H = get_H()

% Transform the smiley face with H
points_h = apply_transformation(points, H, noise);

% Show transformed smile
figure(1)
clf
plot_smile(points, points_h)


% Now let's try to recover H using DLT

% Init our matrix A
A = [];

for i=1:min(n_correspondences, length(points))

    % Get the corresponding points
    x_i = points(:, i);
    x_i_p = points_h(:, i);

    % Get the two rows that represent the contraints we get from this correspondence
    Ai = get_Ai(x_i, x_i_p);

    % Append these rows to our matrix A
    A = [A; Ai];

    % Plot each correspondence that we use as a black circle on the figure
    plot_correspondence(x_i, x_i_p)

end

% Now compute the transformation H_dlt from the matrix A that we have constructed
H_dlt = compute_H(A)

% Apply the transformation according to DLT to the original smile and see what we get
points_dlt = H_dlt * points;

% Plot the points we had against the points transformed using H_dlt
figure(2)
clf
plot_H_vs_dlt(points_h, points_dlt);
