function points = init_smile()

    % Create Smile

    % Init points array
    points = [];

    % Create points for circle
    t = linspace(0, 360, 1000);
    x = cosd(t);
    y = sind(t);

    points = [points [x; y]];

    % Create points for eyes
    n = 100;
    x = -0.3*ones(1, n);
    y = linspace(0.1, 0.5, n);
    points = [points [x; y]];

    x =  0.3*ones(1, n);
    y = linspace(0.1, 0.5, n);
    points = [points [x; y]];

    % Create smile
    t = linspace(200, 340, 200);
    x = 0.618*cosd(t);
    y = 0.618*sind(t);
    points = [points [x; y]];

    % Homogeneous
    points(3, :) = 1;

    % Shuffle points so we get them in a random order
    points = points(:, randperm(length(points)));


end
